clear
clc

Q0 = 2.3;
z = 0.5;
Q = zeros(9,12);
t = zeros(9,12);

Datos = xlsread('Ensayos Calendar');

  for i=1:length(Datos(1,:))/2
      for j=1:length(Datos(:,1))
        Q(i,j) = Datos(j,2*i-1);
        t(i,j) = Datos(j,2*i);
      end
  end
 
T = [303.15,318.15,333.15];
SOC = [0.3,0.65,1];

T1 = ones(1,length(Q(1,:)))*T(1);
T2 = ones(1,length(Q(1,:)))*T(2);
T3 = ones(1,length(Q(1,:)))*T(3);
T = [T1;T1;T1;T2;T2;T2;T3;T3;T3];

SOC1 = ones(1,length(Q(1,:)))*SOC(1);
SOC2 = ones(1,length(Q(1,:)))*SOC(2);
SOC3 = ones(1,length(Q(1,:)))*SOC(3);
SOC = [SOC1;SOC2;SOC3;SOC1;SOC2;SOC3;SOC1;SOC2;SOC3];

F = @(x)[
    
    x(1)*exp(x(2)*SOC(1,1))*exp(x(3)/T(1,1))*(t(1,1)^z) - Q(1,1);
    x(1)*exp(x(2)*SOC(1,2))*exp(x(3)/T(1,2))*(t(1,2)^z) - Q(1,2);
    x(1)*exp(x(2)*SOC(1,3))*exp(x(3)/T(1,3))*(t(1,3)^z) - Q(1,3);
    x(1)*exp(x(2)*SOC(1,4))*exp(x(3)/T(1,4))*(t(1,4)^z) - Q(1,4);
    x(1)*exp(x(2)*SOC(1,5))*exp(x(3)/T(1,5))*(t(1,5)^z) - Q(1,5);
    x(1)*exp(x(2)*SOC(1,6))*exp(x(3)/T(1,6))*(t(1,6)^z) - Q(1,6);
    x(1)*exp(x(2)*SOC(1,7))*exp(x(3)/T(1,7))*(t(1,7)^z) - Q(1,7);
    x(1)*exp(x(2)*SOC(1,8))*exp(x(3)/T(1,8))*(t(1,8)^z) - Q(1,8);
    
    x(1)*exp(x(2)*SOC(2,1))*exp(x(3)/T(2,1))*(t(2,1)^z) - Q(2,1);
    x(1)*exp(x(2)*SOC(2,2))*exp(x(3)/T(2,2))*(t(2,2)^z) - Q(2,2);
    x(1)*exp(x(2)*SOC(2,3))*exp(x(3)/T(2,3))*(t(2,3)^z) - Q(2,3);
    x(1)*exp(x(2)*SOC(2,4))*exp(x(3)/T(2,4))*(t(2,4)^z) - Q(2,4);
    x(1)*exp(x(2)*SOC(2,5))*exp(x(3)/T(2,5))*(t(2,5)^z) - Q(2,5);
    x(1)*exp(x(2)*SOC(2,6))*exp(x(3)/T(2,6))*(t(2,6)^z) - Q(2,6);
    x(1)*exp(x(2)*SOC(2,7))*exp(x(3)/T(2,7))*(t(2,7)^z) - Q(2,7);
    x(1)*exp(x(2)*SOC(2,8))*exp(x(3)/T(2,8))*(t(2,8)^z) - Q(2,8);

    x(1)*exp(x(2)*SOC(3,1))*exp(x(3)/T(3,1))*(t(3,1)^z) - Q(3,1);
    x(1)*exp(x(2)*SOC(3,2))*exp(x(3)/T(3,2))*(t(3,2)^z) - Q(3,2);
    x(1)*exp(x(2)*SOC(3,3))*exp(x(3)/T(3,3))*(t(3,3)^z) - Q(3,3);
    x(1)*exp(x(2)*SOC(3,4))*exp(x(3)/T(3,4))*(t(3,4)^z) - Q(3,4);
    x(1)*exp(x(2)*SOC(3,5))*exp(x(3)/T(3,5))*(t(3,5)^z) - Q(3,5);
    x(1)*exp(x(2)*SOC(3,6))*exp(x(3)/T(3,6))*(t(3,6)^z) - Q(3,6);
    x(1)*exp(x(2)*SOC(3,7))*exp(x(3)/T(3,7))*(t(3,7)^z) - Q(3,7);
    x(1)*exp(x(2)*SOC(3,8))*exp(x(3)/T(3,8))*(t(3,8)^z) - Q(3,8);
    x(1)*exp(x(2)*SOC(3,9))*exp(x(3)/T(3,9))*(t(3,9)^z) - Q(3,9);
    x(1)*exp(x(2)*SOC(3,10))*exp(x(3)/T(3,10))*(t(3,10)^z) - Q(3,10);
    x(1)*exp(x(2)*SOC(3,11))*exp(x(3)/T(3,11))*(t(3,11)^z) - Q(3,11);

    x(1)*exp(x(2)*SOC(4,1))*exp(x(3)/T(4,1))*(t(4,1)^z) - Q(4,1);
    x(1)*exp(x(2)*SOC(4,2))*exp(x(3)/T(4,2))*(t(4,2)^z) - Q(4,2);
    x(1)*exp(x(2)*SOC(4,3))*exp(x(3)/T(4,3))*(t(4,3)^z) - Q(4,3);
    x(1)*exp(x(2)*SOC(4,4))*exp(x(3)/T(4,4))*(t(4,4)^z) - Q(4,4);
    x(1)*exp(x(2)*SOC(4,5))*exp(x(3)/T(4,5))*(t(4,5)^z) - Q(4,5);
    x(1)*exp(x(2)*SOC(4,6))*exp(x(3)/T(4,6))*(t(4,6)^z) - Q(4,6);
    x(1)*exp(x(2)*SOC(4,7))*exp(x(3)/T(4,7))*(t(4,7)^z) - Q(4,7);

    x(1)*exp(x(2)*SOC(5,1))*exp(x(3)/T(5,1))*(t(5,1)^z) - Q(5,1);
    x(1)*exp(x(2)*SOC(5,2))*exp(x(3)/T(5,2))*(t(5,2)^z) - Q(5,2);
    x(1)*exp(x(2)*SOC(5,3))*exp(x(3)/T(5,3))*(t(5,3)^z) - Q(5,3);
    x(1)*exp(x(2)*SOC(5,4))*exp(x(3)/T(5,4))*(t(5,4)^z) - Q(5,4);
    x(1)*exp(x(2)*SOC(5,5))*exp(x(3)/T(5,5))*(t(5,5)^z) - Q(5,5);
    x(1)*exp(x(2)*SOC(5,6))*exp(x(3)/T(5,6))*(t(5,6)^z) - Q(5,6);
    x(1)*exp(x(2)*SOC(5,7))*exp(x(3)/T(5,7))*(t(5,7)^z) - Q(5,7);
    x(1)*exp(x(2)*SOC(5,8))*exp(x(3)/T(5,8))*(t(5,8)^z) - Q(5,8);
    x(1)*exp(x(2)*SOC(5,9))*exp(x(3)/T(5,9))*(t(5,9)^z) - Q(5,9);

    x(1)*exp(x(2)*SOC(6,1))*exp(x(3)/T(6,1))*(t(6,1)^z) - Q(6,1);
    x(1)*exp(x(2)*SOC(6,2))*exp(x(3)/T(6,2))*(t(6,2)^z) - Q(6,2);
    x(1)*exp(x(2)*SOC(6,3))*exp(x(3)/T(6,3))*(t(6,3)^z) - Q(6,3);
    x(1)*exp(x(2)*SOC(6,4))*exp(x(3)/T(6,4))*(t(6,4)^z) - Q(6,4);
    x(1)*exp(x(2)*SOC(6,5))*exp(x(3)/T(6,5))*(t(6,5)^z) - Q(6,5);
    x(1)*exp(x(2)*SOC(6,6))*exp(x(3)/T(6,6))*(t(6,6)^z) - Q(6,6);
    x(1)*exp(x(2)*SOC(6,7))*exp(x(3)/T(6,7))*(t(6,7)^z) - Q(6,7);
    x(1)*exp(x(2)*SOC(6,8))*exp(x(3)/T(6,8))*(t(6,8)^z) - Q(6,8);
    x(1)*exp(x(2)*SOC(6,9))*exp(x(3)/T(6,9))*(t(6,9)^z) - Q(6,9);
    x(1)*exp(x(2)*SOC(6,10))*exp(x(3)/T(6,10))*(t(6,10)^z) - Q(6,10);

    x(1)*exp(x(2)*SOC(7,1))*exp(x(3)/T(7,1))*(t(7,1)^z) - Q(7,1);
    x(1)*exp(x(2)*SOC(7,2))*exp(x(3)/T(7,2))*(t(7,2)^z) - Q(7,2);
    x(1)*exp(x(2)*SOC(7,3))*exp(x(3)/T(7,3))*(t(7,3)^z) - Q(7,3);
    x(1)*exp(x(2)*SOC(7,4))*exp(x(3)/T(7,4))*(t(7,4)^z) - Q(7,4);
    x(1)*exp(x(2)*SOC(7,5))*exp(x(3)/T(7,5))*(t(7,5)^z) - Q(7,5);
    x(1)*exp(x(2)*SOC(7,6))*exp(x(3)/T(7,6))*(t(7,6)^z) - Q(7,6);
    x(1)*exp(x(2)*SOC(7,7))*exp(x(3)/T(7,7))*(t(7,7)^z) - Q(7,7);
    
    x(1)*exp(x(2)*SOC(8,1))*exp(x(3)/T(8,1))*(t(8,1)^z) - Q(8,1);
    x(1)*exp(x(2)*SOC(8,2))*exp(x(3)/T(8,2))*(t(8,2)^z) - Q(8,2);
    x(1)*exp(x(2)*SOC(8,3))*exp(x(3)/T(8,3))*(t(8,3)^z) - Q(8,3);
    x(1)*exp(x(2)*SOC(8,4))*exp(x(3)/T(8,4))*(t(8,4)^z) - Q(8,4);
    x(1)*exp(x(2)*SOC(8,5))*exp(x(3)/T(8,5))*(t(8,5)^z) - Q(8,5);
    x(1)*exp(x(2)*SOC(8,6))*exp(x(3)/T(8,6))*(t(8,6)^z) - Q(8,6);
    x(1)*exp(x(2)*SOC(8,7))*exp(x(3)/T(8,7))*(t(8,7)^z) - Q(8,7);
    x(1)*exp(x(2)*SOC(8,8))*exp(x(3)/T(8,8))*(t(8,8)^z) - Q(8,8);
    x(1)*exp(x(2)*SOC(8,9))*exp(x(3)/T(8,9))*(t(8,9)^z) - Q(8,9);
    x(1)*exp(x(2)*SOC(8,10))*exp(x(3)/T(8,10))*(t(8,10)^z) - Q(8,10);
    x(1)*exp(x(2)*SOC(8,11))*exp(x(3)/T(8,11))*(t(8,11)^z) - Q(8,11);
    x(1)*exp(x(2)*SOC(8,12))*exp(x(3)/T(8,12))*(t(8,12)^z) - Q(8,12);

    x(1)*exp(x(2)*SOC(9,1))*exp(x(3)/T(9,1))*(t(9,1)^z) - Q(9,1);
    x(1)*exp(x(2)*SOC(9,2))*exp(x(3)/T(9,2))*(t(9,2)^z) - Q(9,2);
    x(1)*exp(x(2)*SOC(9,3))*exp(x(3)/T(9,3))*(t(9,3)^z) - Q(9,3);
    x(1)*exp(x(2)*SOC(9,4))*exp(x(3)/T(9,4))*(t(9,4)^z) - Q(9,4);
    x(1)*exp(x(2)*SOC(9,5))*exp(x(3)/T(9,5))*(t(9,5)^z) - Q(9,5);
    x(1)*exp(x(2)*SOC(9,6))*exp(x(3)/T(9,6))*(t(9,6)^z) - Q(9,6);
    x(1)*exp(x(2)*SOC(9,7))*exp(x(3)/T(9,7))*(t(9,7)^z) - Q(9,7);
    x(1)*exp(x(2)*SOC(9,8))*exp(x(3)/T(9,8))*(t(9,8)^z) - Q(9,8);
    x(1)*exp(x(2)*SOC(9,9))*exp(x(3)/T(9,9))*(t(9,9)^z) - Q(9,9);
    x(1)*exp(x(2)*SOC(9,10))*exp(x(3)/T(9,10))*(t(9,10)^z) - Q(9,10);
    x(1)*exp(x(2)*SOC(9,11))*exp(x(3)/T(9,11))*(t(9,11)^z) - Q(9,11);
    x(1)*exp(x(2)*SOC(9,12))*exp(x(3)/T(9,12))*(t(9,12)^z) - Q(9,12);
   
];
      
X0 = [2.145e7,0.69,-6.541*10^3];
[x,ssq,cnt] = LMFsolve(F,X0);

f = x(1)*Q0;
g = x(2);
h = x(3);

figure()
for j=1:9
    time = (0:1:1000);
    Q_loss = f*exp(x(2)*SOC(j,1))*exp(x(3)/T(j,1))*time.^z;
    plot(time,Q_loss/Q0*100)
    hold on
end

for i=1:length(Datos(1,:))/2
   for j=1:length(Datos(:,1))
        if (SOC(i,j)==SOC1(1,j))
        plot(t(i,:), 100*Q(i,:), 'o')
        hold on
        axis([0 1000 0 50]);
        end
        if (SOC(i,j)==SOC2(1,j))
        plot(t(i,:), 100*Q(i,:), 'square')
        hold on
        axis([0 1000 0 50]);
        end
        if (SOC(i,j)==SOC3(1,j))
        plot(t(i,:), 100*Q(i,:), 'diamond')
        hold on
        axis([0 1000 0 50]);
        end
    end
end
